/*
 * Decompiled with CFR 0.152.
 */
package net.dowhatimean.jme;

import com.hp.hpl.jena.n3.N3Exception;
import com.hp.hpl.jena.rdf.listeners.StatementListener;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;

public class ModelEditor {
    private static final int WINDOW_MIN_WIDTH = 400;
    private static final int WINDOW_MIN_HEIGHT = 200;
    private static final Random random = new Random(19790715L);
    Model boundModel;
    JFrame window;
    JTextArea turtleTextArea;
    JLabel cursorPositionLabel;
    JPanel buttons;
    StatementListener listener;
    boolean outOfSync;
    boolean weAreEditingTheModel = false;

    public static ModelEditor open(Model sourceModel) {
        return new ModelEditor(sourceModel, "Jena Model Editor");
    }

    public static ModelEditor open(Model sourceModel, String title) {
        return new ModelEditor(sourceModel, title + " - Jena Model Editor");
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Please specify one or more RDF filenames or URLs.");
            return;
        }
        HashMap<String, Model> filenamesToModels = new HashMap<String, Model>();
        for (int i = 0; i < args.length; ++i) {
            if (!filenamesToModels.containsKey(args[i])) {
                String url = args[i];
                if (url.indexOf(":") == -1) {
                    url = "file:" + url;
                }
                Model m = ModelFactory.createDefaultModel();
                String lang = url.endsWith(".n3") || url.endsWith(".ttl") ? "N3" : "RDF/XML";
                m.read(url, lang);
                filenamesToModels.put(args[i], m);
            }
            Model m = (Model)filenamesToModels.get(args[i]);
            ModelEditor.open(m, args[i]);
        }
    }

    private ModelEditor(Model sourceModel, String title) {
        this.window = new JFrame(title){

            public void dispose() {
                ModelEditor.this.boundModel.unregister((ModelChangedListener)ModelEditor.this.listener);
                super.dispose();
            }
        };
        this.boundModel = sourceModel;
        this.init();
        this.fetchTurtleFromModel();
        this.window.setVisible(true);
    }

    protected synchronized void addTurtleToModel() {
        this.lockModel();
        Model contents = this.getContentsAsModel();
        if (contents == null) {
            return;
        }
        Iterator it = contents.getNsPrefixMap().keySet().iterator();
        while (it.hasNext()) {
            String prefix = (String)it.next();
            String uri = contents.getNsPrefixURI(prefix);
            if (uri.equals(this.boundModel.getNsPrefixURI(prefix))) continue;
            this.boundModel.setNsPrefix(prefix, uri);
        }
        this.boundModel.add(contents);
        this.turtleTextArea.requestFocusInWindow();
        this.unlockModel();
    }

    protected synchronized void removeTurtleFromModel() {
        this.lockModel();
        Model contents = this.getContentsAsModel();
        if (contents == null) {
            return;
        }
        Iterator it = contents.getNsPrefixMap().keySet().iterator();
        while (it.hasNext()) {
            String prefix = (String)it.next();
            this.boundModel.removeNsPrefix(prefix);
        }
        this.boundModel.remove(contents);
        this.turtleTextArea.requestFocusInWindow();
        this.unlockModel();
    }

    protected synchronized void replaceModelWithTurtle() {
        this.lockModel();
        Model contents = this.getContentsAsModel();
        if (contents == null) {
            return;
        }
        Iterator it = this.boundModel.getNsPrefixMap().keySet().iterator();
        while (it.hasNext()) {
            String prefix = (String)it.next();
            this.boundModel.removeNsPrefix(prefix);
        }
        this.boundModel.setNsPrefixes((PrefixMapping)contents);
        this.boundModel.removeAll();
        this.boundModel.add(contents);
        this.turtleTextArea.requestFocusInWindow();
        this.unlockModel();
        this.outOfSync = false;
    }

    protected void fetchTurtleFromModel() {
        StringWriter writer = new StringWriter();
        this.boundModel.write((Writer)writer, "N3");
        this.setContents(writer.toString());
        this.turtleTextArea.requestFocusInWindow();
        this.moveCursorTo(1, 1);
        this.outOfSync = false;
    }

    protected String getContentsAsTurtle() {
        return this.turtleTextArea.getText();
    }

    protected Model getContentsAsModel() {
        Model result = ModelFactory.createDefaultModel();
        StringReader reader = new StringReader(this.getContentsAsTurtle());
        try {
            result.read((Reader)reader, "", "N3");
            return result;
        }
        catch (N3Exception ex) {
            Pattern p = Pattern.compile(".*\\[([0-9]+):([0-9]+)\\] (.*)");
            Matcher m = p.matcher(ex.getMessage());
            if (!m.matches()) {
                throw new RuntimeException("Unexpected error format: " + ex.getMessage());
            }
            JOptionPane.showMessageDialog(this.window, m.group(3), "Parse Error", 0);
            int line = Integer.parseInt(m.group(1));
            int column = Integer.parseInt(m.group(2));
            this.highlightCharacter(line, column);
            return null;
        }
    }

    protected void setContents(String text) {
        this.turtleTextArea.setText(text);
    }

    protected int getCurrentCursorLine() {
        try {
            return this.turtleTextArea.getLineOfOffset(this.turtleTextArea.getCaretPosition()) + 1;
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    protected int getCurrentCursorColumn() {
        try {
            int line = this.turtleTextArea.getLineOfOffset(this.turtleTextArea.getCaretPosition());
            return this.turtleTextArea.getCaretPosition() - this.turtleTextArea.getLineStartOffset(line) + 1;
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    protected void highlightCharacter(int line, int column) {
        try {
            this.turtleTextArea.requestFocusInWindow();
            int offset = this.turtleTextArea.getLineStartOffset(line - 1) + column - 1;
            this.turtleTextArea.setCaretPosition(offset + 1);
            this.turtleTextArea.moveCaretPosition(offset);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    protected void moveCursorTo(int line, int column) {
        try {
            this.turtleTextArea.requestFocusInWindow();
            int offset = this.turtleTextArea.getLineStartOffset(line - 1) + column - 1;
            this.turtleTextArea.setCaretPosition(offset);
            this.notifyCursorPositionChanged();
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    protected void notifyCursorPositionChanged() {
        this.cursorPositionLabel.setText(this.getCurrentCursorLine() + " : " + this.getCurrentCursorColumn());
    }

    protected synchronized void notifyConcurrentChange() {
        if (this.weAreEditingTheModel || this.outOfSync) {
            return;
        }
        this.outOfSync = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(ModelEditor.this.window, "The model has been changed by another part of the system.\nRe-fetch the contents of the model to get the latest changes.", "Concurrent Change", 2);
            }
        });
    }

    private void lockModel() {
        this.weAreEditingTheModel = true;
        this.boundModel.enterCriticalSection(false);
    }

    private void unlockModel() {
        this.weAreEditingTheModel = false;
        this.boundModel.leaveCriticalSection();
    }

    private void init() {
        this.listener = new StatementListener(){

            public void addedStatement(Statement s) {
                ModelEditor.this.notifyConcurrentChange();
            }

            public void removedStatement(Statement s) {
                ModelEditor.this.notifyConcurrentChange();
            }
        };
        this.boundModel.register((ModelChangedListener)this.listener);
        this.turtleTextArea = new JTextArea();
        this.turtleTextArea.setFont(new Font("Monospaced", 0, 12));
        this.turtleTextArea.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                ModelEditor.this.notifyCursorPositionChanged();
            }
        });
        JScrollPane scroller = new JScrollPane(this.turtleTextArea, 22, 30);
        scroller.setPreferredSize(new Dimension(400, 300));
        this.buttons = new JPanel();
        this.buttons.setLayout(new BoxLayout(this.buttons, 3));
        this.buttons.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 16));
        this.makeButton("Add this to the model", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ModelEditor.this.addTurtleToModel();
            }
        });
        this.makeButton("Remove this from the model", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ModelEditor.this.removeTurtleFromModel();
            }
        });
        this.makeButton("Fetch contents of the model", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ModelEditor.this.fetchTurtleFromModel();
            }
        });
        this.makeButton("Replace contents of the model", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ModelEditor.this.replaceModelWithTurtle();
            }
        });
        this.cursorPositionLabel = new JLabel("Status bar");
        this.cursorPositionLabel.setFont(new Font("Dialog", 0, 10));
        this.buttons.add(Box.createVerticalGlue());
        this.buttons.add(this.cursorPositionLabel);
        Container contentPane = this.window.getContentPane();
        contentPane.add((Component)scroller, "Center");
        contentPane.add((Component)this.buttons, "East");
        contentPane.add(Box.createRigidArea(new Dimension(16, 0)), "West");
        contentPane.add(Box.createRigidArea(new Dimension(0, 12)), "North");
        contentPane.add(Box.createRigidArea(new Dimension(0, 12)), "South");
        this.window.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                int width = ModelEditor.this.window.getWidth();
                int height = ModelEditor.this.window.getHeight();
                boolean doResize = false;
                if (width < 400) {
                    width = 400;
                    doResize = true;
                }
                if (height < 200) {
                    height = 200;
                    doResize = true;
                }
                if (!doResize) {
                    return;
                }
                ModelEditor.this.window.setSize(width, height);
            }
        });
        this.window.setDefaultCloseOperation(2);
        this.window.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.window.setLocation(random.nextInt(screen.width - this.window.getWidth()), random.nextInt(screen.height - this.window.getHeight()));
    }

    private void makeButton(String label, ActionListener action) {
        JButton newButton = new JButton(label){

            public Dimension getMaximumSize() {
                Dimension dim = super.getMaximumSize();
                return new Dimension(Short.MAX_VALUE, (int)dim.getHeight());
            }
        };
        newButton.addActionListener(action);
        this.buttons.add(newButton);
        this.buttons.add(Box.createRigidArea(new Dimension(0, 6)));
    }
}

